const ResourceModel = require('../../../model/TaskResourceModel');
// eslint-disable-next-line no-unused-vars
const ResourceFilterModel = require('../../../model/filter/ResourceFilterModel');
// eslint-disable-next-line no-unused-vars
const ManageGroupsControls = require('../../controlSection/adminControls/ManageGroupsControls');
const RestStatisticsContent = require('../../statistics/RestStatisticsContent');
// eslint-disable-next-line no-unused-vars
const StatisticsNavigationView = require('../../navigation/statistics/StatisticsNavigationView');
const RestStatisticsControls = require('../../controlSection/statistics/RestStatisticsControls');
const XmlrpcStatisticsContentLayout = require('./XmlrpcStatisticsContentLayout');

/**
 * @class RestStatisticsContentLayout
 * @extends XmlrpcStatisticsContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 * @property {Marionette.Region} controls
 * @property {Marionette.Region} navigation
 */
const RestStatisticsContentLayout = XmlrpcStatisticsContentLayout.extend({

    template: require('./tpl/RestStatisticsContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    initialize() {
        this.statSourceResource = new ResourceModel();
    },

    getControls() {
        return new RestStatisticsControls({
            model: this.statSourceResource
        });
    },

    getContent() {
        return new RestStatisticsContent({
            model: this.statSourceResource
        });
    }
});

module.exports = RestStatisticsContentLayout;
