/* eslint max-statements: [1, 11] */
/* eslint max-len: [1, 130] */

// eslint-disable-next-line no-unused-vars
const GridLayout = require('./../../components/grid/GridLayout');
// eslint-disable-next-line no-unused-vars
const SchedulerGridView = require('./../../schedulersList/SchedulerGridView');
const ContentLayout = require('./ContentLayout');
// eslint-disable-next-line no-unused-vars
const SchedulersListControlSection = require('../../controlSection/schedulersList/SchedulersListControlSection');
const SandboxNotificationsPaginationLayout = require('../../sandboxNotifications/SandboxNotificationsPaginationLayout');
const SandboxNotificationsFilterView = require('../../controlSection/sandboxNotifications/SandboxNotificationsFilterView');
const SandboxNotificationContentView = require('../../sandboxNotifications/SandboxNotificationContentView');
const SandboxNotificationsListView = require('../../sandboxNotifications/SandboxNotificationsListView');

/**
 * @class SandboxNotificationsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} filter
 * @property {Marionette.Region} content
 * @property {Marionette.Region} pagination
 * @property {Marionette.Region} notifications
 */
const SandboxNotificationsContentLayout = ContentLayout.extend({

    className: 'section section_inbox',

    template: require('./tpl/SandboxNotificationsContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.patchParent();

        this.filter.close();
        this.content.close();
        this.pagination.close();
        this.notifications.close();

        this.filter.show(this.getFilter());
        this.content.show(this.getContent());
        this.pagination.show(this.getPagination());
        this.notifications.show(this.getNotifications());
    },

    getFilter() {
        return new SandboxNotificationsFilterView({
            user: this.model.getUser(),
            model: this.model.getSandboxNotifications().getFilterParams().clone(),
            collection: this.model.getSandboxNotifications()
        });
    },

    getNotifications() {
        return new SandboxNotificationsListView({
            collection: this.model.getSandboxNotifications()
        });
    },

    getContent() {
        return new SandboxNotificationContentView({
            model: this.model
        });
    },

    getPagination() {
        return new SandboxNotificationsPaginationLayout({
            collection: this.model.getSandboxNotifications()
        });
    },

    serializeData() {
        return {
            isAdmin: this.model.getUser().isAdmin()
        };
    },

    patchParent() {
        this.options.parent.$el.find('.wrap').addClass('wrap_inbox');
    }
});

module.exports = SandboxNotificationsContentLayout;
