const GridLayout = require('./../../components/grid/GridLayout');
const SchedulerGridView = require('./../../schedulersList/SchedulerGridView');
const ContentLayout = require('./ContentLayout');

/**
 * @class SchedulersListContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const SchedulersListContentLayout = ContentLayout.extend({
    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.model.getSchedulers(),
            gridClass: SchedulerGridView,
            gridOptions: {
                autoUpdateEnabled: Boolean(this.model.getPageProps().isAutoupdateEnabled)
            }
        });
    }
});

module.exports = SchedulersListContentLayout;
