/* eslint max-len: [1, 130] */

const ServiceNotificationModel = require('../../../model/ServiceNotificationModel');
const ServiceNotificationsGridView = require('../../serviceNotifications/grid/ServiceNotificationsGridView');
const ServiceNotificationAddConfirmView = require('../../serviceNotifications/modals/ServiceNotificationAddConfirmView');

/**
 * @class ServiceNotificationsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} notifications
 */
const ServiceNotificationsContentLayout = Marionette.Layout.extend({

    className: 'section section_slim',

    template: require('./tpl/ServiceNotificationsContentLayout.hbs'),

    ui: {
        createTrigger: '.create_message_trigger'
    },

    events: {
        'click @ui.createTrigger': 'onCreateMessage'
    },

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.notifications.close();
        this.notifications.show(this.getNotifications());
    },

    onCreateMessage() {
        (new ServiceNotificationAddConfirmView({
            model: new ServiceNotificationModel(),
            collection: this.model.getServiceNotifications()
        })).show();
    },

    getNotifications() {
        return new ServiceNotificationsGridView({
            collection: this.model.getServiceNotifications()
        });
    },

    serializeData() {}
});

module.exports = ServiceNotificationsContentLayout;
