const ContentLayout = require('./ContentLayout');
const ServiceThreadsView = require('../../admin/serviceThreads/ServiceThreadsView');

/**
 * @class ServiceThreadsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 */
const ServiceThreadsContentLayout = ContentLayout.extend({

    template: require('./tpl/ServiceThreadsContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new ServiceThreadsView({
            collection: this.model.getServiceThreads()
        });
    }
});

module.exports = ServiceThreadsContentLayout;
