const ContentLayout = require('./ContentLayout');
const SingleGroupView = require('../../admin/singleGroup/SingleGroupView');
const AdminMainNavigationView = require('../../navigation/admin/AdminMainNavigationView');

/**
 * @class SingleGroupContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const SingleGroupContentLayout = ContentLayout.extend({

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        if (this.navigation) {
            this.navigation.close();
            this.navigation.show(this.getNavigation());
        }
        this.content.close();
        this.content.show(this.getContent());
    },

    getNavigation() {
        return new AdminMainNavigationView({
            model: this.model
        });
    },

    getContent() {
        const groupName = String(this.model.getPageProps().key).toUpperCase();

        return new SingleGroupView({
            model: this.model.getUserGroups().findWhere({ name: groupName })
        });
    }
});

module.exports = SingleGroupContentLayout;
