/* eslint max-len: [1, 130] */

const SingleResourceControlSectionLayout = require('../../controlSection/singleResource/SingleResourceControlSectionLayout');
const SingleResourceCommonView = require('../../singleResource/SingleResourceCommonView');
const SingleTaskContentLayout = require('./SingleTaskContentLayout');
const SingleTaskSubsView = require('../../singleTask/SingleTaskSubsView');

/**
 * @class SingleResourceContentLayout
 * @extends SingleTaskContentLayout
 *
 * @property {CoreApplication} model
 */
const SingleResourceContentLayout = SingleTaskContentLayout.extend({

    template: require('./tpl/SingleResourceContentLayout.hbs'),

    options: {
        contentConfig: {
            view: {
                fetchMethod: null,
                collectionProp: null,
                contentViewClass: SingleResourceCommonView
            },
            dependant: {
                fetchMethod: 'fetchDependant',
                canBeUpdated: true,
                collectionProp: 'dependant',
                selectableGrid: true,
                contentViewClass: SingleTaskSubsView
            }
        }
    },

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */
    regions: {
        content: '#single-task-content'
    },

    onRender() {
        document.title = ('Resource #' + this._model.get('id') + ' ' + this._model.get('type'));

        this.controls.close();
        this.controls.show(this.getControls());

        this.setContent(this.getAction());
    },

    getControls() {
        return new SingleResourceControlSectionLayout({
            model: this.model.getResource(),
            layout: this,
            coreApp: this.model,
            taskProps: this.model.getProps()
        });
    },

    getModel() {
        return this.model.getResource();
    }
});

module.exports = SingleResourceContentLayout;
