/* eslint max-statements: [1, 12] */
/* eslint max-len: [1, 130] */

const SingleSchedulerControlSectionLayout = require('../../controlSection/singleScheduler/SingleSchedulerControlSectionLayout');
const SingleSchedulerCommonViewFactory = require('../../singleScheduler/SingleSchedulerCommonViewFactory');
const SingleSchedulerTaskContextView = require('../../singleScheduler/SingleSchedulerTaskContextView');
const SingleSchedulerChildTasksView = require('../../singleScheduler/SingleSchedulerChildTasksView');
const SingleSchedulerChildOnceTasksView = require('../../singleScheduler/SingleSchedulerChildOnceTasksView');
const SingleTaskContentLayout = require('./SingleTaskContentLayout');
// eslint-disable-next-line no-unused-vars
const SingleTaskContextView = require('../../singleTask/SingleTaskContextView');
// eslint-disable-next-line no-unused-vars
const BasicCollection = require('../../../collection/BasicCollection');
// eslint-disable-next-line no-unused-vars
const ContentLayout = require('./ContentLayout');
// eslint-disable-next-line no-unused-vars
const error = require('../../../error');
const app = require('../../../app');

/**
 * @class SingleSchedulerContentLayout
 * @extends SingleTaskContentLayout
 *
 * @property {CoreApplication} model
 */
const SingleSchedulerContentLayout = SingleTaskContentLayout.extend({

    template: require('./tpl/SingleTaskContentLayout.hbs'),

    ui: {
        loader: '.preloader'
    },

    options: _.extend({}, SingleTaskContentLayout.prototype.options, {
        loaderMessage: 'Loading scheduler data..',
        contentConfig: {
            view: {
                fetchMethod: 'fetchCustomParameters',
                canBeUpdated: false,
                collectionProp: null,
                contentViewClass: SingleSchedulerCommonViewFactory
            },
            context: {
                fetchMethod: 'fetchTaskContext',
                canBeUpdated: false,
                collectionProp: null,
                contentViewClass: SingleSchedulerTaskContextView
            },
            tasks: {
                fetchMethod: 'fetchChildTasks',
                canBeUpdated: false,
                collectionProp: null,
                contentViewClass: SingleSchedulerChildTasksView
            },
            manual: {
                fetchMethod: 'fetchChildOnceTasks',
                canBeUpdated: false,
                collectionProp: null,
                contentViewClass: SingleSchedulerChildOnceTasksView
            }
        }
    }),

    onRender() {
        document.title = ('Scheduler #' + this._model.get('id'));

        this.controls.close();
        this.controls.show(this.getControls());

        this.setContent(this.getAction());
    },

    getModel() {
        return this.model.getScheduler();
    },

    getControls() {
        return new SingleSchedulerControlSectionLayout({
            model: this.getModel(),
            layout: this,
            coreApp: this.model,
            taskProps: this.model.getProps()
        });
    },

    getContentDataCollection(collectionProp) {
        if (!collectionProp) {
            return null;
        }

        if (!collectionProp.includes('.')) {
            return this.model.getTask().get(collectionProp);
        }
        collectionProp = collectionProp.split('.');

        return this.model.getTask().get(collectionProp[0])[collectionProp[1]];
    },

    onClose() {
        SingleTaskContentLayout.prototype.onClose.apply(this, arguments);

        if (!window.location.pathname.includes('scheduler/')) {
            app.dropDraftScheduler();
        }
    }
});

module.exports = SingleSchedulerContentLayout;
