/* eslint max-statements: [1, 19] */
const React = require('react');
const ReactDOM = require('react-dom');
const Provider = require('react-redux').Provider;
const store = require('../../../store/initializedStore');

const SemaphoreWrapper = require('../../../components/SemaphoreWrapper');

/**
 * @class SingleSemaphoreContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const SingleSemaphoreContentLayout = Marionette.Layout.extend({

    className: 'section section_slim',

    template: require('./tpl/SingleSemaphoreContentLayout.hbs'),

    ui: {
        region: '.single-semaphore-content'
    },

    modelEvents: {
        'change:pageProps'() {
            this.trigger('content:replaced');
        }
    },

    onRender() {
        document.title = ('Semaphore #' + this.model.get('pageProps').key);

        this._renderWrapperOfComponents();
    },

    _renderWrapperOfComponents() {
        if (this.ui.region[0]) {
            ReactDOM.render(
                <Provider store={store}>
                    <SemaphoreWrapper
                        id={this.model.get('pageProps').key}
                        pageProps={this.model.get('pageProps')}
                        isAdmin={this.model.get('user').isAdmin()}
                        />
                </Provider>,
                this.ui.region[0]
            );
        }
    },

    destroyReactView() {
        if (this.content && this.content.$el) {
            ReactDOM.unmountComponentAtNode(this.content.$el[0]);
        }
    },

    close() {
        this.destroyReactView();
        this.remove();
        Marionette.Layout.prototype.close.call(this);
        Backbone.View.prototype.remove.call(this);

        return false;
    }
});

module.exports = SingleSemaphoreContentLayout;
