const ContentLayout = require('./ContentLayout');
const TasksStatisticsContent = require('./../../statistics/TasksStatisticsContent');
const StatisticsNavigationView = require('../../navigation/statistics/StatisticsNavigationView');

/**
 * @class StatisticsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 * @property {Marionette.Region} navigation
 */
const StatisticsContentLayout = ContentLayout.extend({

    template: require('./tpl/StatisticsContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    onRender() {
        if (this.navigation) {
            this.navigation.close();
            this.navigation.show(this.getNavigation());
        }

        this.content.close();
        this.content.show(this.getContent());
    },

    getNavigation() {
        return new StatisticsNavigationView({
            model: this.model
        });
    },

    getContent() {
        return new TasksStatisticsContent();
    }
});

module.exports = StatisticsContentLayout;
