const GridLayout = require('./../../components/grid/GridLayout');
const ContentLayout = require('./ContentLayout');
const TasksCompactGridView = require('./../../tasks/tasksGridCompact/grid/TasksCompactGridView');

/**
 * @class TaskListContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication} model
 */
const TaskListContentLayout = ContentLayout.extend({

    className: 'section section_slim',

    onRender() {
        this.content.close();
        this.content.show(this.getContent());
    },

    getContent() {
        return new GridLayout({
            model: this.model,
            collection: this.model.getTasks(),
            gridClass: TasksCompactGridView,
            gridOptions: {
                autoUpdateEnabled: Boolean(this.model.getPageProps().isAutoupdateEnabled)
            }
        });
    }
});

module.exports = TaskListContentLayout;
