const ContentLayout = require('./ContentLayout');
const ResourceModel = require('../../../model/TaskResourceModel');
// eslint-disable-next-line no-unused-vars
const ResourceFilterModel = require('../../../model/filter/ResourceFilterModel');
// eslint-disable-next-line no-unused-vars
const ManageGroupsControls = require('../../controlSection/adminControls/ManageGroupsControls');
const XmlrpcStatisticsContent = require('../../statistics/XmlrpcStatisticsContent');
const StatisticsNavigationView = require('../../navigation/statistics/StatisticsNavigationView');
const XmlrpcStatisticsControls = require('../../controlSection/statistics/XmlrpcStatisticsControls');

/**
 * @class XmlrpcStatisticsContentLayout
 * @extends ContentLayout
 *
 * @property {CoreApplication}   model
 * @property {Marionette.Region} content
 * @property {Marionette.Region} controls
 * @property {Marionette.Region} navigation
 */
const XmlrpcStatisticsContentLayout = ContentLayout.extend({

    template: require('./tpl/XmlrpcStatisticsContentLayout.hbs'),

    /** REGIONS DEFINED DIRECTLY IN TEMPLATE */

    initialize() {
        this.statSourceResource = new ResourceModel();
    },

    getNavigation() {
        return new StatisticsNavigationView({
            model: this.model
        });
    },

    getControls() {
        return new XmlrpcStatisticsControls({
            model: this.statSourceResource
        });
    },

    getContent() {
        return new XmlrpcStatisticsContent({
            model: this.statSourceResource
        });
    }
});

module.exports = XmlrpcStatisticsContentLayout;
