/**
 * Utilizes functionality for mapping layouts.
 *
 * @mixin layoutMapper
 */
const layoutMapper = {

    _convertToEngLayout(sourceValue) {
        const symbols = {
            й: 'q', ц: 'w', у: 'e', к: 'r', е: 't', н: 'y', г: 'u', ш: 'i', щ: 'o', p: '',
            ф: 'a', ы: 's', в: 'd', а: 'f', п: 'g', р: 'h', о: 'j', л: 'k', д: 'l',
            я: 'z', ч: 'x', с: 'c', м: 'v', и: 'b', т: 'n', ь: 'm'
        };

        return sourceValue.replace(/[а-я]/g, toReplace => {
            return symbols[toReplace];
        });
    }
};

module.exports = layoutMapper;
