/**
 * Utilizes functionality for suggests.
 *
 * @mixin suggestMixin
 */
const suggestMixin = {

    _getKeyOrValue(item, target) {
        return item.length === 2 ? item[target === 'key' ? 0 : 1] : item;
    },

    _getKeyValueOf(searchable, target) {
        /* eslint complexity: [1, 12] */

        if (!searchable) {
            return '';
        }

        const context = this.model.get('context');
        const keyValue = context && _.filter(
            context.values,
            item => {
                return item && item.indexOf && item.indexOf(searchable) !== -1;
            }
        )[0];

        switch (target) {
            case 'key':
                return (keyValue && keyValue[0]) || searchable || '';
            case 'value':
                return (keyValue && keyValue[1]) || searchable || '';
            default:
                return keyValue || searchable;
        }
    }
};

module.exports = suggestMixin;
