/* eslint max-len: [1, 130] */

const cookie = require('bemmy/src/blocks/component/cookie');
const app = require('../../app');
const CreateSchedulerTypeSelectModalView = require('../../views/schedulers/modals/CreateSchedulerTypeSelectModalView');
const CreateTaskTypeSelectPopupView = require('../../views/createTask/CreateTaskTypeSelectPopupView');
const CreateResourceTypeSelectPopupView = require('../../views/resources/modals/CreateResourceTypeSelectPopupView');
const PresetsView = require('./presets/PresetsView');
const resources = require('../../resources');
const router = require('../../router');
// eslint-disable-next-line no-unused-vars
const loader = require('../../views/loader');

/**
 * @class MainNavigationView
 * @extends Backbone.Marionette.Layout
 *
 * @property {CoreApplication} model
 */
const MainNavigationView = Marionette.Layout.extend({

    template: require('./tpl/navigation.hbs'),
    className: 'section__nav app_navigation',

    ui: {
        navItems: '.app_main_nav_link'
    },

    events: {
        'click @ui.navItems': 'onSelectMenuItem'
    },

    options: {
        activeClass: 'cur',
        modalsConfig: {
            scheduler: CreateSchedulerTypeSelectModalView,
            task: CreateTaskTypeSelectPopupView,
            resource: CreateResourceTypeSelectPopupView
        }
    },

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    onRender() {
        this.presets.close();
        this.presets.show(this.getPresetsRegion());
        this.markActiveMenuItem();

        app.performance.filter = (Math.round(window.performance.now() - app.performance.epoch)) / 1000;

        if (window.yaCounter28049724 && window.yaCounter28049724.reachGoal && window.location.host === 'sandbox.yandex-team.ru') {
            const params = {
                login: cookie.getYandexLogin(),
                internalRoute: app.performance.internalRoute,
                time: app.performance.filter,
                origin: document.location.pathname + document.location.search
            };

            window.yaCounter28049724.reachGoal('PERFORMANCE_FILTER', params);
        }
    },

    onSelectMenuItem(evtObj) {
        /* eslint max-statements: [1, 13] */

        evtObj.preventDefault();

        const self = this;
        const menuItem = evtObj.currentTarget;

        if (menuItem.classList.contains(this.options.activeClass)) {
            return false;
        }

        if (menuItem.dataset.navTarget.includes('create')) {
            if (menuItem.dataset.navTarget.includes('resource')) {
                resources.resourceTypes().then(types => {
                    const ModalClass = self.getCreateModalClass(menuItem.dataset.createItem);

                    if (ModalClass === null) {
                        throw new Error('Unsupported item type to create.');
                    }

                    (new ModalClass({
                        types,
                        user: self.model.getUser()
                    })).show();
                });
            } else {
                resources.types().then(types => {
                    const ModalClass = self.getCreateModalClass(menuItem.dataset.createItem);

                    if (ModalClass === null) {
                        throw new Error('Unsupported item type to create.');
                    }

                    (new ModalClass({
                        types,
                        user: self.model.getUser()
                    })).show();
                });
            }
        } else if (evtObj.ctrlKey || evtObj.metaKey) {
            window.open(evtObj.currentTarget.dataset.navTarget);
        } else {
            router.navigate(evtObj.currentTarget.dataset.navTarget, { trigger: true });
        }
    },

    getPresetsRegion() {
        return new PresetsView({
            model: this.model,
            collection: this.model.getUser().getPresets()
        });
    },

    getCreateModalClass(createItemName) {
        return this.options.modalsConfig[createItemName] ?
            this.options.modalsConfig[createItemName] :
            null;
    },

    markActiveMenuItem() {
        /* eslint max-statements: [1, 18] */
        /* eslint complexity: [1, 7] */

        let index = -1;
        const currPath = router.getCurrentPathFragment();

        switch (currPath) {
            case '/task/create':
            case '/tasks/create/': {
                index = 0;
                break;
            }
            case '/scheduler/create':
            case '/scheduler/create/': {
                index = 1;
                break;
            }
            default:
        }

        if ((new RegExp('.*scheduler.+edit.*', 'i')).test(currPath)) {
            index = 1;
        }

        if (index !== -1) {
            this.ui.navItems.eq(index).addClass(this.options.activeClass);
        }
    },

    serializeData() {
        const pageProps = this.model.getPageProps();

        return {
            updateEnabled: ((pageProps && pageProps.isAutoupdateEnabled) ? pageProps.isAutoupdateEnabled : false)
        };
    }
});

module.exports = MainNavigationView;
