const router = require('../../../router');
const MainNavigationView = require('../MainNavigationView');
const SandboxModeSwitcher = require('./SandboxModeSwitcher');

/**
 * @class AdminMainNavigationView
 * @extends MainNavigationView
 *
 * @property {Marionette.Region} modeSwitcher
 */
const AdminMainNavigationView = MainNavigationView.extend({

    template: require('./tpl/AdminNavigationView.hbs'),

    onRender() {
        if (this.model.getUser().isAdmin()) {
            this.modeSwitcher.close();
            this.modeSwitcher.show(new SandboxModeSwitcher());
        }

        this.markActiveMenuItem();
    },

    markActiveMenuItem() {
        /* eslint complexity: [1, 10] */
        /* eslint max-statements: [1, 12] */

        let index = -1;

        switch (router.getCurrentPathFragment()) {
            case '/admin/vault':
            case '/admin/vault/': {
                index = 1;
                break;
            }
            case '/admin/groups':
            case '/admin/groups/': {
                index = 0;
                break;
            }
            case '/admin/task-types':
            case '/admin/task-types/': {
                index = 2;
                break;
            }
            case '/admin/semaphores':
            case '/admin/semaphores/': {
                index = 3;
                break;
            }
            default:
        }

        if (index !== -1) {
            this.ui.navItems.eq(index).addClass(this.options.activeClass);
        }
    },

    serializeData() {
        return {};
    }
});

module.exports = AdminMainNavigationView;
