const app = require('../../../app');
const error = require('../../../error');
const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

/**
 * @class SandboxModeSwitchConfirm
 * @extends BasicConfirmDialogView
 *
 * @property {Object} options
 * @property {String} options.targetMode
 */
const SandboxModeSwitchConfirm = BasicConfirmDialogView.extend({

    template: require('./tpl/SandboxModeSwitchConfirm.hbs'),

    events: {
        approve: 'onApprove'
    },

    onApprove() {
        const self = this;

        return $.ajax({
            url: '/api/v1.0/service/status/operation_mode',
            type: 'PUT',
            data: this.options.targetMode,
            dataType: 'json',
            contentType: 'application/json'
        }).done(() => {
            self.close();

            app.vent.trigger(
                'API_MODE_CHANGED',
                self.options.targetMode
            );
        })
            .fail(xhr => {
                self.close();

                error.fromXHR(xhr);
            });
    },

    serializeData() {
        return {
            targetMode: (this.options.targetMode === 'pre_read_only' ?
                'PRE READ ONLY' :
                (this.options.targetMode === 'read_only' ?
                    'READ ONLY' :
                    'NORMAL'
                )
            )
        };
    }

});

module.exports = SandboxModeSwitchConfirm;
