const app = require('../../../app');
// eslint-disable-next-line no-unused-vars
const error = require('../../../error');
const SandboxModeSwitchConfirm = require('./SandboxModeSwitchConfirm');

/**
 * @class SandboxModeSwitcher
 * @extends Backbone.Marionette.ItemView
 */
const SandboxModeSwitcher = Marionette.ItemView.extend({

    tagName: 'td',
    className: 'c sandbox_mode_switcher',

    template: require('./tpl/SandboxModeSwitcher.hbs'),

    events: {
        'bemmy:set .button': 'onModeChange'
    },

    appMode: app.getAppMode(),

    initialize() {
        this.listenTo(app.vent, 'API_MODE_CHANGED', this.onModeChanged);
    },

    serializeData() {
        return { mode: this.appMode };
    },

    onRender() {
        this.$('.button').bemmyButton();
    },

    onBeforeDestroy() {
        this.stopListening(app.vent, 'API_MODE_CHANGED', this.onModeChanged);
    },

    onModeChange(evtObj, modeToSet) {
        (new SandboxModeSwitchConfirm({
            targetMode: modeToSet
        })).show();
    },

    onModeChanged(mode) {
        if (this.appMode !== mode) {
            this.appMode = mode;
            this.render();
        }
    }
});

module.exports = SandboxModeSwitcher;
