const MainNavigationView = require('../MainNavigationView');

/**
 * @class ClientsMainNavigationView
 * @extends MainNavigationView
 *
 * @property {CoreApplication} model
 * @property {Marionette.Region} modeSwitcher
 */
const ClientsMainNavigationView = MainNavigationView.extend(/** @lends ClientsMainNavigationView.prototype */{

    className: 'section__nav',
    template: require('./tpl/ClientsMainNavigation.hbs'),

    options: {
        parentEvent: 'selected:group',
        activeGroup: 'dc'
    },

    ui: _.extend({}, MainNavigationView.prototype.ui, {
        deadClientsTrigger: '.dead_clients_trigger'
    }),

    events: _.extend({}, MainNavigationView.prototype.events, {
        'click @ui.deadClientsTrigger': 'onDeadShow'
    }),

    initialize(options) {
        this.options = _.extend({}, this.options, options);
    },

    onRender() {
        this.markActiveMenuItem();
    },

    onSelectMenuItem(evtObj) {
        evtObj.preventDefault();

        if (!evtObj.currentTarget.classList.contains('cur') &&
            !evtObj.currentTarget.classList.contains('disabled')) {
            this.options.parent.trigger(this.options.parentEvent, evtObj.currentTarget.dataset.action);
            this.$('.cur').removeClass('cur');
            evtObj.currentTarget.classList.add('cur');
        }
    },

    serializeData() {
        const props = this.model.getPageProps();

        return _.extend({}, this.options.sortGroups, {
            active: this.options.activeGroup,
            updateEnabled: (props.isAutoupdateEnabled ? props.isAutoupdateEnabled : false)
        });
    },

    onDeadShow() {
        this.options.parent.trigger('show:dead');
    }
});

module.exports = ClientsMainNavigationView;
