const ClientsMainNavigationView = require('./ClientsMainNavigation');
const ModeSwitcherView = require('../../controlSection/clients/ModeSwitcherView');

/**
 * @class ClientsSecondaryNavigationView
 * @extends ClientsMainNavigationView
 *
 * @property {CoreApplication} model
 * @property {Backbone.VirtualCollection} collection
 */
const ClientsSecondaryNavigationView = ClientsMainNavigationView.extend({

    template: require('./tpl/ClientsSecondaryNavigation.hbs'),

    ui: {
        navItems: '.app_main_nav_link',
        navItemsCnt: '.nav_items_cnt',
        moreItemsCnt: '.button_section-nav'
    },

    options: {
        parentEvent: 'selected:subgroup'
    },

    collectionEvents: {
        'change:mode': 'onModeChange'
    },

    initialize(options) {
        ClientsMainNavigationView.prototype.initialize.apply(this, arguments);

        this.options = _.extend({}, this.options, options);

        this.debRender = _.debounce(this.render, 10).bind(this);
        this.listenTo(this.options.parent, 'selected:group', this.debRender);
        this.listenTo(this.options.parent.collection.collection, 'update:complete', this.debRender);
        this.listenTo(this.options.parent.collection, 'filter', this.debRender);
    },

    onModeChange(mode) {
        this.options.mode = mode;
    },

    onRender() {
        this.modeSwitcher.close();
        this.modeSwitcher.show(this.getModeSwitcher());
        setTimeout(() => {
            this.reflowNavigation();
        }, 0);
    },

    onSelectMenuItem(evtObj) {
        evtObj.preventDefault();

        $('body').animate({
            scrollTop: $('#' + evtObj.currentTarget.dataset.nav).offset().top + 'px'
        });
    },

    reflowNavigation() {
        /* eslint max-statements: [1, 12] */

        const self = this;
        const cntWidth = this.ui.navItemsCnt.width();
        let visibleQnt = 0;
        let visibleWidth = 0;
        const firstLevelNav = this.ui.navItems.filter('a');

        firstLevelNav.each((index, elt) => {
            visibleWidth += ($(elt).width() + (parseInt($(elt).css('margin-left'), 10) * 2));

            if (visibleWidth < cntWidth) {
                visibleQnt++;
            } else {
                return false;
            }
        });

        if (firstLevelNav.length === visibleQnt) {
            this.ui.moreItemsCnt.fadeOut({
                complete() {
                    self.ui.moreItemsCnt.remove();
                }
            });
        } else {
            firstLevelNav.slice(visibleQnt - 1).remove();
            this.ui.moreItemsCnt.find('li').slice(0, visibleQnt - 1).remove();
        }

        this.ui.navItemsCnt.removeClass('not_reflowed');
        this.$('.button').bemmyButton();
    },

    getModeSwitcher() {
        return new ModeSwitcherView({
            parent: this.options.parent,
            model: this.model,
            mode: this.options.mode
        });
    },

    serializeData() {
        const subgroups = this.collection.map(group => {
            return {
                parentGroup: group.get('parentGroup'),
                title: group.get('title'),
                qnt: group.get('items').length
            };
        });

        return {
            total: this.options.parent.collection.length,
            subgroups
        };
    },

    onClose() {
        this.stopListening(this.options.parent, 'selected:group');
        this.stopListening(this.options.parent.collection.collection, 'update:complete');
        this.stopListening(this.options.parent.collection, 'filter');
    }
});

module.exports = ClientsSecondaryNavigationView;
