const PresetManageItemListView = Marionette.CollectionView.extend({

    tagName: 'tbody',
    itemView: require('./PresetManageItemView'),

    onRender() {
        const self = this;

        this.$el.sortable({
            update() {
                self.onReordered();
            }
        });
    },

    onReordered() {
        const self = this;

        this.$('.t__move').each((index, elt) => {
            const model = _.find(self.collection.models, item => {
                return item.cid === elt.dataset.itemId;
            });

            if (model) {
                model.setOrder(index + 1);
            }
        });
    }
});

module.exports = PresetManageItemListView;
