const PresetManageItemView = Marionette.ItemView.extend({

    tagName: 'tr',
    template: require('./tpl/PresetManageItemView.hbs'),

    model: require('../../../../model/filter/FilterModel.js'),

    ui: {
        deleteBtn: '.app_delete_preset'
    },

    events: {
        'click @ui.deleteBtn': 'onDeletePreset'
    },

    serializeData() {
        return {
            id: this.model.cid,
            title: this.model.get('title')
        };
    },

    onDeletePreset() {
        this.model.collection.remove(this.model);
        this.$el.remove();
    }
});

module.exports = PresetManageItemView;
