const BasicConfirmDialogView = require('../../../components/BasicConfirmDialogView');
const PresetManageItemListView = require('./PresetManageItemListView');

const PresetManageView = BasicConfirmDialogView.extend({

    template: require('./tpl/PresetManageView.hbs'),

    onRender() {
        this.presets.close();
        this.presets.show(this.getPresetItems());
    },

    getPresetItems() {
        const collection = this.collection.clone();

        collection.reset(collection.models.filter(model => {
            return model.get('forPage') === collection.getCurrentPage();
        }));

        return new PresetManageItemListView({
            collection
        });
    }
});

module.exports = PresetManageView;
