/**
 * @class SecNavigation
 * @extends Backbone.Marionette.Layout
 *
 * @property {CoreApplication} model
 */
const SecNavigation = Marionette.Layout.extend({

    className: 'section__nav section__nav_bottom',

    ui: {
        navItems: '.c',
        spinner: '.spinner'
    },

    events: {
        'click @ui.navItems': 'onAction'
    },

    options: {
        activeClass: 'cur',
        disabledClass: 'disabled'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);
        this.listenTo(this.options.layout, 'content:replaced', this.onRender);
    },

    onRender() {
        this.hideSpinner();
        this.markCurrentAction();
    },

    onDestroy() {
        this.stopListening(this.options.layout, 'content:replaced', this.onRender);
    },

    onAction(evtObj) {
        evtObj.preventDefault();

        if (evtObj.currentTarget.classList.contains(this.options.disabledClass) ||
            evtObj.currentTarget.classList.contains(this.options.activeClass)) {
            return false;
        }

        this.showSpinner(evtObj.currentTarget);
        this.options.layout.trigger('content:replace', {
            action: evtObj.currentTarget.dataset.action
        });
    },

    markCurrentAction() {
        const self = this;
        const pageAction = this.model.getPageProps().action || 'view';

        this.ui.navItems.removeClass(this.options.activeClass)
            .each((index, elt) => {
                if (elt.dataset.action === pageAction) {
                    elt.classList.add(self.options.activeClass);
                }
            });
    },

    hideSpinner() {
        this.ui.spinner.hide();
    },

    showSpinner(container) {
        $(container).find('.spinner').show();
    },

    onClose() {
        this.stopListening(this.options.layout, 'content:replaced');
    }
});

module.exports = SecNavigation;
