const SecNavigation = require('./SecNavigation');

/**
 * @class SingleResourceSecNavigation
 * @extends SecNavigation
 *
 * @property {CoreApplication} model
 */
const SingleResourceSecNavigation = SecNavigation.extend({

    className: 'section__nav section__nav_bottom section__nav_nobd section__nav_red',

    template: require('./tpl/SingleResourceSecNavigation.hbs'),

    serializeData() {
        return {
            dependantQnt: this.model.getResource().getDependantQnt()
        };
    }
});

module.exports = SingleResourceSecNavigation;
