const SingleTaskSecNavigation = require('./SingleTaskSecNavigation');

/**
 * @class SingleSchedulerSecNavigation
 * @extends SingleTaskSecNavigation
 *
 * @property {CoreApplication} model
 */
const SingleSchedulerSecNavigation = SingleTaskSecNavigation.extend({

    template: require('./tpl/SingleSchedulerSecNavigation.hbs'),

    serializeData() {
        const scheduler = this.model.getScheduler();

        return {
            taskContextQnt: scheduler.task.getContextQnt(),
            id: scheduler.get('id')
        };
    }
});

module.exports = SingleSchedulerSecNavigation;
