const router = require('../../../router');
const MainNavigationView = require('../MainNavigationView');

/**
 * @class StatisticsNavigationView
 * @extends MainNavigationView
 */
const StatisticsNavigationView = MainNavigationView.extend({

    template: require('./tpl/StatisticsNavigationView.hbs'),

    onRender() {
        this.markActiveMenuItem();
    },

    markActiveMenuItem() {
        /* eslint complexity: [1, 12] */

        let index = -1;

        switch (router.getCurrentPathFragment()) {
            case '/statistics':
            case '/statistics/tasks':
            case '/statistics/tasks/': {
                index = 0;
                break;
            }
            case '/statistics/xmlrpc':
            case '/statistics/xmlrpc/': {
                index = 1;
                break;
            }
            case '/statistics/rest':
            case '/statistics/rest/': {
                index = 2;
                break;
            }
            default:
        }

        if (index !== -1) {
            this.ui.navItems.eq(index).addClass(this.options.activeClass);
        }
    },

    serializeData() {
        return {};
    }
});

module.exports = StatisticsNavigationView;
