const PageCapacitySwitcherView = require('./pageCapacitySwitcher/PageCapacitySwitcherView');
const PaginatorView = require('./paging/PaginatorView');

const PaginationLayout = Marionette.Layout.extend({

    className: 'section__pages',

    template: require('./tpl/PaginationLayout.hbs'),

    ui: {
        qntCnt: '.qnt'
    },

    /** REGIONS DEFINED DIRECTLY IN TEMPLATES */

    collectionEvents: {
        sync: 'onCollectionSync'
    },

    onShow() {
        this.paging.close();
        this.capacitySwitcher.close();

        this.paging.show(this.getPagination());
        this.capacitySwitcher.show(this.getCapacitySwitcher());

        this.onCollectionSync();
    },

    onCollectionSync() {
        const cnt = this.collection.getPagingOptions();

        this.$(this.ui.qntCnt).text(cnt && cnt.total);
    },

    getPagination() {
        return new PaginatorView({
            collection: this.collection,
            gridCnt: this.options.gridCnt
        });
    },

    getCapacitySwitcher() {
        return new PageCapacitySwitcherView({
            collection: this.collection,
            gridCnt: this.options.gridCnt
        });
    }
});

module.exports = PaginationLayout;
