const PaginationGridScrollerMixin = require('../../components/grid/mixin/PaginationGridScrollerMixin');

/**
 * @class PageCapacitySwitcherView
 * @mixes PaginationGridScrollerMixin
 * @extends Marionette.ItemView
 */
const PageCapacitySwitcher = Marionette.ItemView.mixin(PaginationGridScrollerMixin).extend({

    className: 'radiogroup',

    template: require('./tpl/PageCapacitySwitcher.hbs'),

    ui: {
        buttons: '.button'
    },

    events: {
        'bemmy:set': 'onCapacityChange'
    },

    collectionEvents: {
        sync: 'render'
    },

    onRender() {
        this.ui.buttons.bemmyButton();
    },

    onCapacityChange(evtObj, pageCapacity) {
        evtObj.preventDefault();

        this.collection.setPageCapacity(parseInt(pageCapacity, 10));
        this.makeGridCntVisible();
    },

    serializeData() {
        const settings = this.collection.getPagingOptions();
        const templateSettings = {
            capacity: [
                { cap: 20, active: (settings.pageCapacity === 20) },
                { cap: 50, active: (settings.pageCapacity === 50) },
                { cap: 100, active: (settings.pageCapacity === 100) }
            ]
        };

        return templateSettings;
    }
});

module.exports = PageCapacitySwitcher;
