require('bemmy/blocks/button');

const PaginationGridScrollerMixin = require('../../components/grid/mixin/PaginationGridScrollerMixin');

/**
 * @class PaginatorView
 * @mixes PaginationGridScrollerMixin
 * @extends Marionette.View
 *
 * @param {TasksCollection} collection
 */
const PaginatorView = Marionette.ItemView.mixin(PaginationGridScrollerMixin).extend({

    template: require('./tpl/PaginatorView.hbs'),
    tagName: 'ul',
    className: 'pages__list',

    ui: {
        pages: '.app_paginator_page',
        nextPage: '.app_paginator_next'
    },

    events: {
        'click @ui.pages': 'onGetPage'
    },

    collectionEvents: {
        sync: 'render'
    },

    options: {
        pageSetLength: 5,

        activeClass: 'cur',
        nextPageTrigger: 'app_paginator_next'
    },

    onGetPage(evtObj) {
        evtObj.preventDefault();

        const pagTrigger = $(evtObj.currentTarget);
        let targetPage = this.collection.getPagingOptions().page;

        if (pagTrigger.hasClass(this.options.activeClass)) {
            return false;
        }

        targetPage = parseInt(pagTrigger.data('page'), 10) ||
            (targetPage + (pagTrigger.hasClass(this.options.nextPageTrigger) ? 1 : -1));
        this.collection.setPage(targetPage);
        this.collection.setSelected(false);
        this.makeGridCntVisible();
    },

    serializeData() {
        /* eslint max-statements: [1, 22] */
        /* eslint complexity: [1, 9] */
        /* eslint max-depth: [1, 4] */

        const settings = this.collection.getPagingOptions();
        const currentSet = Math.ceil(settings.page / this.options.pageSetLength);
        const startPage = ((currentSet - 1) * this.options.pageSetLength) + 1;
        const totalPages = Math.ceil(settings.total / settings.pageCapacity);
        const templateSettings = {
            pages: [],
            prev: startPage > 1,
            next: (startPage + this.options.pageSetLength - 1) < totalPages
        };
        const page = settings.page;
        let i;

        if (totalPages > 10) {
            let rightOffset = 10 - page;

            for (i = 1; i <= totalPages; i++) {
                if (i === 2 && page > 6) {
                    templateSettings.pages.push({
                        dotted: true
                    });

                    i = page - 4;
                    if (totalPages - page < 6) {
                        i = totalPages - 10;
                    }

                    rightOffset = 4;
                } else if (i === page + rightOffset && i < totalPages - 1) {
                    templateSettings.pages.push({
                        dotted: true
                    });

                    i = totalPages - 1;
                } else {
                    templateSettings.pages.push({
                        page: i,
                        current: i === page
                    });
                }
            }
        } else {
            for (i = 1; i <= totalPages; i++) {
                templateSettings.pages.push({
                    page: i,
                    current: i === page
                });
            }
        }

        return templateSettings;
    }
});

module.exports = PaginatorView;
