const app = require('../../app');
const BasicFilterLayout = require('../controlSection/filter/BasicFilterLayout');
const FormAcceptBehavior = require('../behaviors/forms/FormAcceptBehavior');
const TaskTypeAutocompleteView = require('../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');

/**
 * @class ReleaseFilter
 * @extends BasicFilterLayout
 *
 * @property {ResourceFilterModel} model
 */
const ReleaseFilter = BasicFilterLayout.extend({

    template: require('./tpl/ReleaseFilter.hbs'),

    /** REGIONS ARE DEFINED DIRECTLY IN THE TEMPLATE */

    ui: _.extend({}, BasicFilterLayout.prototype.ui, {
        type: '.filter_type',
        state: '.filter_state',
        applyBtn: '.filter_apply',
        resetBtn: '.filter_reset'
    }),

    events: _.extend({}, BasicFilterLayout.prototype.events, {
        'click @ui.applyBtn': 'onApply',
        'click @ui.resetBtn': 'onReset',
        'change @ui.state': 'onStateChange'
    }),

    behaviors: {
        FormAcceptBehavior: {}
    },

    initialize() {
        this.listenTo(this, FormAcceptBehavior.EVENTS.ACCEPT_EVENT, this.onApply);
    },

    onReset(evtObj) {
        evtObj.preventDefault();
        this.model.setDefaults();

        return false;
    },

    onRender() {
        this.$('.button').bemmyButton();
        this.$('.select').bemmySelect();

        this.typeSelector.close();
        this.typeSelector.show(this.getTypeSelector());

        this.bindUIElements();
    },

    onStateChange(evtObj) {
        this.model.set('type', evtObj.target.value);
    },

    getTypeSelector() {
        return new TaskTypeAutocompleteView({
            lazy: 400,
            items: this.options.releaseProps.resourceTypes,
            value: this.model.get('resource_type'),
            model: this.model,
            showAnyItem: true,
            placeHolder: 'Resource type',
            modelTargetKey: 'resource_type',
            selectClassName: 'filter_type'
        });
    },

    /**
     * @override
     * @param {Backbone.Model} filterValues - filter model
     */
    updateLastFilter(filterValues) {
        const defaultFilter = app.request('DEFAULT_FILTER');

        defaultFilter.releaseList.set(filterValues);
        defaultFilter.releaseList.saveFilterState();
    },

    serializeData() {
        return _.extend({}, this.model.toJSON(), {
            states: _.map(this.options.releaseProps.releaseStatuses, item => {
                return { label: item.toUpperCase(), key: item };
            }),
            updateEnabled: this.options.isAutoupdateEnabled
        });
    },

    onClose() {
        this.stopListening(this, FormAcceptBehavior.EVENTS.ACCEPT_EVENT);
    }
});

module.exports = ReleaseFilter;
