const ReleaseGridHeaderView = require('./ReleaseGridHeaderView');
const ReleaseGridBodyView = require('./ReleaseGridBodyView');
const BasicCollection = require('../../../collection/BasicCollection');
const BasicGridView = require('../../tasks/basicGrid/BasicGridView');

/**
 * @class ReleaseGridView
 * @extends BasicGridView
 * @property {ReleasesCollection} collection
 */
const ReleaseGridView = BasicGridView.extend({

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: false,
        sortable: true,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: ReleaseGridBodyView,
        headerClass: ReleaseGridHeaderView
    })
});

module.exports = ReleaseGridView;
