/* eslint no-prototype-builtins: 0 */

const SingleTaskReleasedResources = require('../../singleTask/SingleTaskReleasedResources');
const clipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');

/**
 * @class ReleaseResources
 * @extends SingleTaskReleasedResources
 */
const ReleaseResources = SingleTaskReleasedResources.extend({

    tagName: 'div',
    className: '',

    template: require('./tpl/ReleaseResources.hbs'),

    ui: {
        md5Cnt: '.md5'
    },

    events: {
        'dblclick @ui.md5Cnt': 'onMd5Select'
    },

    initialize() {},

    /**
     * Just for prevent event propagation
     * @returns {boolean}
     */
    onMd5Select() {
        return false;
    },

    onRender() {
        clipboardClientMixin.initializeClipboardClient(
            '.http-proxy-copier',
            'Resource ID has been copied to clipboard.'
        );
    },

    serializeData() {
        const released = [];
        const rest = [];

        this.collection
            .toJSON()
            .forEach(resource => {
                if (resource.attributes.hasOwnProperty('released')) {
                    released.push(resource);
                } else {
                    rest.push(resource);
                }
            });

        return {
            message: this.model.get('message'),
            loading: !(released.length || rest.length),
            restResources: rest,
            releasedResources: released
        };
    }
});

module.exports = ReleaseResources;
