const error = require('../../../error');
const Timer = require('../../../helpers/utils/Timer');
const ReleaseResources = require('./ReleaseResources');
const TaskResourcesCollection = require('../../../collection/TaskResourcesCollection');

const clipboardClientMixin = require('../../components/clipboardClient/ClipboardClientMixin');

/**
 * @class ReleaseRowView
 * @extends Marionette.Layout
 *
 * @property {ReleaseModel} model
 * @property {Marionette.Region} releaseResources
 */
const ReleaseRowView = Marionette.Layout.extend({

    tagName: 'tr',
    template: require('./tpl/ReleaseGridRow.hbs'),

    options: {
        rowOpenedClass: 't__opened',
        descCntOpenedClass: 't__desc_open'
    },

    ui: {
        toggler: '.link__toggler',
        descrCnt: '.t__desc'
    },

    events: {
        dblclick: 'onDescrToggle',
        'click @ui.toggler': 'onDescrToggle'
    },

    initialize() {
        this._model = this.model.clone();
    },

    onDescrToggle(e) {
        e.preventDefault();

        if (!this.releaseResources.currentView) {
            this._model
                .set('id', this._model.get('task_id'))
                .fetch({ reset: true })
                .done(() => {
                    this.releaseResources.close();
                    this.releaseResources.show(new ReleaseResources({
                        model: this._model,
                        collection: new TaskResourcesCollection(this._model.get('resources'))
                    }));
                })
                .fail(() => {
                    error.message('There is a problem with getting releases info.', {
                        reload: false
                    });
                });
        }

        this.$el.toggleClass(this.options.rowOpenedClass);
        this.ui.descrCnt.toggleClass(this.options.descCntOpenedClass);

        return false;
    },

    serializeData() {
        const serialized = this.model.toJSON();

        serialized.created = Timer.serializeTimeMark(this.model.get('created'));

        return serialized;
    },

    onRender() {
        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'Task ID has been copied to clipboard.'
        );
    }
});

module.exports = ReleaseRowView;
