/* eslint camelcase: 0 */

const app = require('../../../app');
const router = require('../../../router');
// eslint-disable-next-line no-unused-vars
const ResourceModel = require('../../../model/ResourceModel');
const BasicConfirmDialogViewWithUserType = require('../../components/BasicConfirmDialogViewWithUserType');
const TaskTypeAutocompleteView = require('../../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');
const CreateTaskTypeSelectPopupView = require('../../createTask/CreateTaskTypeSelectPopupView');

/**
 * @class CreateResourceTypeSelectPopupView
 * @extends CreateTaskTypeSelectPopupView
 */
const CreateResourceTypeSelectPopupView = CreateTaskTypeSelectPopupView.extend({

    template: require('./tpl/CreateResourceTypeSelectPopupView.hbs'),

    options: _.extend({}, CreateTaskTypeSelectPopupView.prototype.options, {
        typeSelectorPlaceholder: 'Select type for a new resource'
    }),

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    initialize(options) {
        this.options = _.extend({}, this.options, options);
        this.model = new ResourceModel();
        this.model.parse();

        BasicConfirmDialogViewWithUserType.prototype.initialize.apply(this, arguments);
    },

    onApprove() {
        const resource = this.model;

        if (resource && resource.get('type')) {
            resource.set({ resourceType: resource.get('type') }, { silent: true });
        }

        if (resource !== null && resource.get('resourceType') !== '') {
            this.ui.spinner.removeClass('hidden');

            this.updateUserTypeList('userResourcesTypesList', resource.get('resourceType'), () => {
                this.loadResourcePage();
            });
        }
    },

    getTypeSelector() {
        return new TaskTypeAutocompleteView({
            model: this.model,
            items: this.options.types,
            value: '',
            placeHolder: this.options.typeSelectorPlaceholder,
            modelTargetKey: 'resourceType',
            selectClassName: this.options.typeSelectorInputClass
        });
    },

    loadResourcePage() {
        app.setDraftResource(this.model);

        this.close();
        router.navigate('/resource/create', { trigger: true });
    },

    serializeData() {
        return {
            userTypeList: this.getUserTypeList('userResourcesTypesList')
        };
    }
});

module.exports = CreateResourceTypeSelectPopupView;
