const error = require('../../error');

/**
 * @class SandboxNotificationContentView
 * @extends Marionette.ItemView
 *
 * @property {CoreApplication} model
 */
const SandboxNotificationContentView = Marionette.ItemView.extend({

    className: 'inbox__content',

    template: require('./tpl/SandboxNotificationContentView.hbs'),

    options: {
        loading: false,
        sent: true
    },

    initialize() {
        this.listenTo(this.model.getSandboxNotifications(), 'reselected', this.updateContent);
    },

    onRender() {
        this.$el.toggleClass('inbox__content_alert', !this.options.sent);
    },

    serializeData() {
        let selected;

        if (!this.options.loading) {
            selected = this.model.getSandboxNotifications().getSelected();
        }

        return _.extend({}, this.options, (selected ? selected.serializeNotification() : {}));
    },

    updateContent() {
        const self = this;
        const selected = this.model.getSandboxNotifications().getSelected();

        this.options.sent = true;

        if (selected) {
            this.options.loading = true;
            this.render();

            selected.fetchAdditionalData()
                .always(() => {
                    self.options.loading = false;
                    self.options.sent = selected.get('sent');

                    self.render();
                })
                .fail(() => {
                    error.message(
                        'Can not fetch notification data. Please try later or select another notification.',
                        { reload: false }
                    );
                });
        }
    },

    onClose() {
        this.stopListening(this.model.getSandboxNotifications(), 'reselected');
    }
});

module.exports = SandboxNotificationContentView;
