/**
 * @class SandboxNotificationView
 * @extends Marionette.ItemView
 *
 * @property {SandboxNotificationModel} model
 */
const SandboxNotificationView = Marionette.ItemView.extend({

    className: 'inbox__item',

    template: require('./tpl/SandboxNotificationView.hbs'),

    options: {
        selectedItemClass: 'inbox__item_open'
    },

    events: {
        click: 'onNotificationSelect'
    },

    modelEvents: {
        change: 'render'
    },

    onRender() {
        this.toggleSelectedClass();
    },

    toggleSelectedClass() {
        this.$el.toggleClass(this.options.selectedItemClass, this.model.get('selected'));
    },

    serializeData() {
        return this.model.serializeNotification();
    },

    onNotificationSelect() {
        const current = (this.model.collection ? this.model.collection.getSelected() : null);

        if (current) {
            current.set('selected', false);
        }

        this.model.set('selected', true);

        if (this.model.collection) {
            this.model.collection.trigger('reselected');
        }
    }

});

module.exports = SandboxNotificationView;
