/* eslint camelcase: 0 */

const app = require('../../../app');
const error = require('../../../error');
const router = require('../../../router');
// eslint-disable-next-line no-unused-vars
const TaskModel = require('../../../model/TaskModel');
const SchedulerModel = require('../../../model/SchedulerModel');
const BasicConfirmDialogViewWithUserType = require('../../components/BasicConfirmDialogViewWithUserType');
const TaskTypeAutocompleteView = require('../../controlSection/filter/selects/autocomplete/TaskTypeAutocompleteView');
const CreateTaskTypeSelectPopupView = require('../../createTask/CreateTaskTypeSelectPopupView');

/**
 * @class CreateSchedulerTypeSelectModalView
 * @extends CreateTaskTypeSelectPopupView
 */
const CreateSchedulerTypeSelectModalView = CreateTaskTypeSelectPopupView.extend({

    template: require('./tpl/CreateSchedulerTypeSelectModalView.hbs'),

    options: _.extend({}, CreateTaskTypeSelectPopupView.prototype.options, {
        typeSelectorPlaceholder: 'Select type for a new scheduler'
    }),

    /** REGIONS DEFINED DIRECTLY IN THE TEMPLATE */

    initialize(options) {
        this.options = _.extend({}, this.options, options);
        this.model = new SchedulerModel();

        this.model.parse();

        BasicConfirmDialogViewWithUserType.prototype.initialize.apply(this, arguments);
    },

    onApprove() {
        const self = this;
        const task = this.model.getTask();

        if (task !== null && task.get('type') !== '') {
            this.model.attributes = {
                task_type: task.get('type')
            };

            this.ui.spinner.removeClass('hidden');

            $.ajax({
                url: '/api/v1.0/scheduler',
                type: 'POST',
                data: JSON.stringify({
                    task_type: task.get('type')
                }),
                dataType: 'json',
                contentType: 'application/json'
            }).done(response => {
                self.model.set(SchedulerModel.prototype.parse.call(self.model, response));

                self.updateUserTypeList.bind(self)('userSchedulersTypesList', task.get('type'), () => {
                    self.loadSchedulerPage();
                });
            }).fail(() => {
                error.message('Can not create a new scheduler. Check that you have enough rights.');
                self.close();
            });
        }
    },

    setModelType(type) {
        const task = this.model.getTask();

        task.set('type', type);
    },

    getTypeSelector() {
        return new TaskTypeAutocompleteView({
            model: this.model.getTask(),
            items: this.options.types,
            value: '',
            placeHolder: this.options.typeSelectorPlaceholder,
            modelTargetKey: 'type',
            selectClassName: this.options.typeSelectorInputClass
        });
    },

    loadSchedulerPage() {
        app.setDraftScheduler(this.model);
        this.close();
        router.navigate('/scheduler/' + this.model.get('id') + '/view', { trigger: true });
    },

    serializeData() {
        return {
            userTypeList: this.getUserTypeList('userSchedulersTypesList')
        };
    }
});

module.exports = CreateSchedulerTypeSelectModalView;
