const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');
const SchedulersCollection = require('../../../collection/SchedulersCollection');

/**
 * @class SchedulerRemoveConfirmView
 * @extends BasicConfirmDialogView
 *
 * @property {SchedulerModel} model
 */
const SchedulerRemoveConfirmView = BasicConfirmDialogView.extend({

    template: require('./tpl/SchedulerRemoveConfirmView.hbs'),

    onApprove() {
        SchedulersCollection.batchAction(SchedulersCollection.BATCH_OPERATIONS.DELETE, [this.model]);
        this.close();
    }

});

module.exports = SchedulerRemoveConfirmView;
