// eslint-disable-next-line no-unused-vars
const app = require('../../app');
// eslint-disable-next-line no-unused-vars
const error = require('../../error');
// eslint-disable-next-line no-unused-vars
const BasicTaskLayout = require('../tasks/tasksGrid/row/BasicTaskLayout');
const TaskSelectorView = require('../tasks/tasksGrid/row/TaskSelectorView');

const clipboardClientMixin = require('../components/clipboardClient/ClipboardClientMixin');

/**
 * @class SchedulerRowView
 * @extends Marionette.Layout
 *
 * @property {SchedulerModel} model
 */
const SchedulerRowView = Marionette.Layout.extend({

    template: require('./tpl/SchedulerRowView.hbs'),
    tagName: 'tr',

    modelEvents: {
        sync: 'render',
        change: 'render'
    },

    behaviors: {
        SchedulerControllerBehavior: {}
    },

    onRender() {
        if (this.options.selectable) {
            this.selector.close();
            this.selector.show(new TaskSelectorView({
                model: this.model
            }));
        }

        clipboardClientMixin.initializeClipboardClient(
            '.id-proxy-copier',
            'ID has been copied to clipboard.'
        );
    },

    serializeData() {
        return _.extend({
            selectable: this.options.selectable,
            canBeStarted: this.model.canBeStarted(),
            canBeStartedOnce: this.model.canBeStartedOnce(),
            canBeStopped: this.model.canBeStopped(),
            canBeEdited: this.model.canBeEdited()
        }, this.model.serialize());
    }
});

module.exports = SchedulerRowView;
