const ServiceNotificationRemoveConfirmView = require('../modals/ServiceNotificationRemoveConfirmView');
const ServiceNotificationEditConfirmView = require('../modals/ServiceNotificationEditConfirmView');

/**
 * @class ServiceNotificationsGridRowView
 * @extends Marionette.ItemView
 *
 * @property {ServiceNotificationModel} model
 */
const ServiceNotificationsGridRowView = Marionette.ItemView.extend({

    tagName: 'tr',
    className: 't__inactive',

    template: require('./tpl/ServiceNotificationsGridRowView.hbs'),

    ui: {
        editTrigger: '.edit_trigger',
        removeTrigger: '.remove_trigger'
    },

    events: {
        'click @ui.editTrigger': 'onEdit',
        'click @ui.removeTrigger': 'onRemove'
    },

    onEdit() {
        (new ServiceNotificationEditConfirmView({
            model: this.model
        })).show();
    },

    onRemove() {
        (new ServiceNotificationRemoveConfirmView({
            model: this.model
        })).show();
    }
});

module.exports = ServiceNotificationsGridRowView;
