const ServiceNotificationsGridHeaderView = require('./ServiceNotificationsGridHeaderView');
const ServiceNotificationsGridBodyView = require('./ServiceNotificationsGridBodyView');
const BasicCollection = require('../../../collection/BasicCollection');
const BasicGridView = require('../../tasks/basicGrid/BasicGridView');

/**
 * @class ServiceNotificationsGridView
 * @extends BasicGridView
 * @property {ServiceNotificationsCollection} collection
 */
const ServiceNotificationsGridView = BasicGridView.extend({

    className: 'section__t',

    template: require('./tpl/ServiceNotificationsGridView.hbs'),

    options: _.extend({}, BasicGridView.prototype.options, {
        selectable: false,
        sortType: BasicCollection.SORT_TYPE.SERVER,

        bodyClass: ServiceNotificationsGridBodyView,
        headerClass: ServiceNotificationsGridHeaderView
    })
});

module.exports = ServiceNotificationsGridView;
