const BasicConfirmDialogView = require('../../components/BasicConfirmDialogView');

/**
 * @class ServiceNotificationEditConfirmView
 * @extends BasicConfirmDialogView
 *
 * @property {ServiceNotificationModel} model
 */
const ServiceNotificationEditConfirmView = BasicConfirmDialogView.extend({

    template: require('./tpl/ServiceNotificationEditConfirmView.hbs'),

    ui: {
        content: '.content textarea',
        severitySelector: '.severity_selector'
    },

    events: {
        'bemmy:set @ui.severitySelector': 'onSeverityChange',
        'change @ui.content': 'onContentChange'
    },

    onRender() {
        this.$('.button').bemmyButton();
        this.$('.textarea').bemmyTextarea();
    },

    onApprove() {
        this.model.save();
        this.close();
    },

    onContentChange() {
        this.model.set('content', this.ui.content.val());
    },

    onSeverityChange(evtObj, value) {
        this.model.set('severity', value);
    }
});

module.exports = ServiceNotificationEditConfirmView;
