const InfoMessage = require('../../components/globalMessage/InfoMessage');
const ErrorMessage = require('../../components/globalMessage/ErrorMessage');
const NotificationsMessage = require('../../components/globalMessage/NotificationMessage');
const ServiceNotificationModel = require('../../../model/ServiceNotificationModel');

const ServiceNotificationsMonitorItemView = NotificationsMessage.extend({

    initialize() { },

    onRender() {
        switch (this.model.get('severity')) {
            case ServiceNotificationModel.SEVERITY.INFO: {
                this.$el.addClass(InfoMessage.prototype.className);
                break;
            }
            case ServiceNotificationModel.SEVERITY.CRITICAL: {
                this.$el.addClass(ErrorMessage.prototype.className);
                break;
            }
            default:
        }
    },

    serializeData() {
        return {
            close: true,
            reload: false,
            message: this.model.get('content'),
            autoClose: false
        };
    },

    onCloseEvent(e) {
        e.preventDefault();

        this.model.set('markedAsClosed', true);
        this.close();
    }
});

module.exports = ServiceNotificationsMonitorItemView;
