const error = require('../../error');
const ClipboardClientMixin = require('../components/clipboardClient/ClipboardClientMixin');
const TaskRemoveConfirmView = require('../tasks/taskRemoveConfirm/ResourceRemoveConfirmView');

const ResourceLinkView = Marionette.ItemView.mixin(ClipboardClientMixin).extend({

    tagName: 'tr',
    className: 'resource-link',

    template: require('./tpl/ResourceLinkView.hbs'),

    ui: {
        remove: '.remove_btn'
    },

    events: {
        'click @ui.remove': 'onRemove',
        'click .target-link': 'onTargetLinkSelect'
    },

    serializeData() {
        return _.extend({}, this.options, this.model.toJSON());
    },

    onRender() {
        this.initializeClipboardClient(
            '.http-proxy-copier',
            'Link has been copied to clipboard.'
        );
    },

    onRemove() {
        const self = this;

        (new TaskRemoveConfirmView({
            model: this.model,
            onApprove() {
                const popup = this;

                self.$el.addClass('loading');

                $.ajax({
                    url: '/api/v1.0/resource/' + self.options.resource_id + '/source/' + self.getHostName(),
                    type: 'DELETE',
                    dataType: 'json',
                    contentType: 'application/json'
                })
                    .done(() => {
                        self.model.collection.remove(self.model);
                        popup.close();
                    })
                    .fail(error.fromXHR)
                    .always(() => {
                        self.$el.removeClass('loading');
                    });
            }
        })).show();
    },

    getHostName() {
        const link = this.model.get('link');
        const fullHostName = link && link.split('/')[2];

        if (fullHostName) {
            return fullHostName.replace(/:[0-9]+/, '').split('.')[0];
        }
    },

    onTargetLinkSelect(evtObj) {
        const range = document.createRange();

        range.selectNodeContents(evtObj.currentTarget);

        const sel = window.getSelection();

        sel.removeAllRanges();
        sel.addRange(range);
    }
});

module.exports = ResourceLinkView;
