/**
 *
 * @property {TaskResourceModel} model
 * @property {Backbone.Collection} collection - Synthetic collection stores resource's links
 */
const ResourceLinksView = Marionette.CollectionView.extend({

    tagName: 'table',
    className: 't__inner',

    itemView: require('./ResourceLinkView'),

    collectionEvents: {
        remove: 'onLinkRemove'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        if (this.options.type === 'rsync') {
            this.modelEvents = { 'change:http': 'actualizeHostSet' };
        }

        this.itemViewOptions = {
            linkable: (_.isUndefined(this.options.linkable) ? false : this.options.linkable),
            actionBtn: (_.isUndefined(this.options.actionBtn) ? false : this.options.actionBtn),
            resource_id: this.model.get('id'),
            type: this.options.type
        };
    },

    onLinkRemove() {
        /* eslint camelcase: 0 */

        this.model.set(this.options.type, {
            links: this.collection.map(link => {
                return link.get('link');
            })
        });
    },

    getSetOfHosts() {
        return this.model.get('http').links.map(link => {
            return link.split('/')[2].replace(/:[0-9]+/, '');
        });
    },

    actualizeHostSet() {
        const hosts = this.getSetOfHosts();

        this.collection.set(this.collection.filter(link => {
            let match = false;
            const linkContent = link.get('link');

            for (let q = 0; q < hosts.length; q++) {
                if (linkContent.includes(hosts[q])) {
                    match = true;
                    break;
                }
            }

            return match;
        }));
    }
});

module.exports = ResourceLinksView;
