const error = require('../../../error');

/**
 * @class ResourceAttributeView
 * @extend Marionette.ItemView
 *
 * @property {Backbone.Model} model
 */
const ResourceAttributeView = Marionette.ItemView.extend({

    tagName: 'tr',

    template: require('./tpl/ResourceAttributeView.hbs'),

    options: {
        editMode: false
    },

    ui: {
        remove: '.remove_btn',
        apply: '.apply_btn',
        edit: '.edit_btn',
        name: '.attr_name input',
        value: '.attr_value input'
    },

    events: {
        'click @ui.edit': 'onEdit',
        'click @ui.apply': 'onApply',
        'click @ui.remove': 'onRemove'
    },

    serializeData() {
        const attrs = _.clone(this.model.attributes);

        attrs.canBeChanged = this.options.canBeChanged;
        attrs.editMode = this.options.editMode;

        return attrs;
    },

    onEdit() {
        this.options.editMode = true;
        this.render();
    },

    onRender() {
        this.$('.input').bemmyInput();
    },

    onApply() {
        const self = this;
        const attrName = this.ui.name.val();
        const attrValue = this.ui.value.val();

        if (attrName && attrValue) {
            $.ajax({
                url: '/api/v1.0/resource/' +
                    this.options.resource.get('id') +
                    '/attribute/' +
                    this.model.get('name'),
                type: 'PUT',
                data: JSON.stringify({
                    name: attrName,
                    value: attrValue
                }),
                dataType: 'json',
                contentType: 'application/json'
            })
                .done(() => {
                    self.model.set({
                        name: attrName,
                        value: attrValue
                    });

                    self.options.editMode = false;
                    self.render();
                })
                .fail(error.fromXHR);
        }
    },

    onRemove() {
        const self = this;

        return $.ajax({
            url: ('/api/v1.0/resource/' + this.options.resource.get('id') + '/attribute/' + this.model.get('name')),
            type: 'DELETE'
        })
            .done(() => {
                self.model.collection.remove([self.model]);
            })
            .fail(error.fromXHR);
    }
});

module.exports = ResourceAttributeView;
