const error = require('../../../error');

/**
 * @class ResourceAttributesView
 * @extend Marionette.CompositeView
 *
 * @property {TaskResourceModel} model
 */
const ResourceAttributesView = Marionette.CompositeView.extend({

    tagName: 'table',
    className: 't t_max t_mini t_nobd',

    template: require('./tpl/ResourceAttributesView.hbs'),

    itemView: require('./ResourceAttributeView'),
    itemViewContainer: 'tbody',

    ui: {
        name: '.new_attr_name input',
        value: '.new_attr_value input',
        add: '.new_attr_add'
    },

    events: {
        'click @ui.add': 'onAdd'
    },

    collectionEvents: {
        all: 'onAttributesChange'
    },

    initialize(options) {
        this.options = _.extend({}, this.options, options);

        this.itemViewOptions = {
            resource: this.model,
            canBeChanged: this.model.canBeChanged()
        };
    },

    onRender() {
        this.$('.input').bemmyInput();
    },

    onAttributesChange() {
        this.model.set('attributes', this.serializeAttrs());
    },

    onAdd() {
        const self = this;
        const attrName = this.ui.name.val();
        const attrValue = this.ui.value.val();

        if (attrName && attrValue) {
            $.ajax({
                url: ('/api/v1.0/resource/' + this.model.get('id') + '/attribute'),
                type: 'POST',
                data: JSON.stringify({
                    name: attrName,
                    value: attrValue
                }),
                dataType: 'json',
                contentType: 'application/json'
            })
                .done(() => {
                    self.collection.add(new Backbone.Model({
                        name: attrName,
                        value: attrValue
                    }));

                    self.ui.name.val('');
                    self.ui.value.val('');
                })
                .fail(error.fromXHR);
        }
    },

    serializeAttrs() {
        const attrs = {};

        this.collection.each(attr => {
            attrs[attr.get('name')] = attr.get('value');
        });

        return attrs;
    },

    serializeData() {
        return { canBeChanged: this.model.canBeChanged() };
    }
});

module.exports = ResourceAttributesView;
