const BasicCollection = require('../../collection/BasicCollection');
const TasksCompactGridView = require('../tasks/tasksGridCompact/grid/TasksCompactGridView');
const GridLayout = require('../components/grid/GridLayout');

const SingleSchedulerChildOnceTasksView = Marionette.Layout.extend({

    className: 'section__i',
    template: require('./tpl/SingleSchedulerChildOnceTasksView.hbs'),

    onRender() {
        this.childOnceTasks.close();
        this.childOnceTasks.show(new GridLayout({
            model: this.model,
            collection: this.model.childOnceTasks,
            gridClass: TasksCompactGridView,
            gridOptions: {
                selectable: false,
                sortType: BasicCollection.SORT_TYPE.CLIENT
            }
        }));
    }
});

module.exports = SingleSchedulerChildOnceTasksView;
