const BasicCollection = require('../../collection/BasicCollection');
const TasksCompactGridView = require('../tasks/tasksGridCompact/grid/TasksCompactGridView');
const GridLayout = require('../components/grid/GridLayout');

const SingleSchedulerChildTasksView = Marionette.Layout.extend({

    className: 'section__i',
    template: require('./tpl/SingleSchedulerChildTasksView.hbs'),

    onRender() {
        this.childTasks.close();
        this.childTasks.show(new GridLayout({
            model: this.model,
            collection: this.model.childTasks,
            gridClass: TasksCompactGridView,
            gridOptions: {
                selectable: false,
                sortType: BasicCollection.SORT_TYPE.CLIENT
            }
        }));
    }
});

module.exports = SingleSchedulerChildTasksView;
